var default_boyan_header_number = 6;
var default_page_index = '2000';
var table_header_names = ['Sub', 'Name', 'Value', 'Type', 'Default', 'Save', 'Comment']

var t0;
var t1;
var eds_object;
t0 = performance.now();

$(function()
{
	$(document).on('click', '.index_number', function()
	{
        $('.index_number').removeClass("selected")
        $(this).addClass("selected");
    });

    $(document).on('click', '.accordion-header', function()
	{
        localStorage.setItem("selected_accordion_header", $(this).index());
    });

    $(document).on('mouseover', '.index_number', function()
	{
        $(this).addClass("hover");
    });

	$(document).on('mouseout', '.index_number', function()
	{
        $(this).removeClass("hover");
	});
});

$(document).ready(function()
{
	get_set_value.set_eds_object();
	get_set_value.set_expert_page_configuration();
	//get saved data
	var selected_page_index = localStorage.getItem("selected_page_index");
	if (selected_page_index == null)
	{
		var selected_page_index = default_page_index;
	}
	var selected_boyan_header = localStorage.getItem("selected_accordion_header");
	if (selected_boyan_header == null)
	{
		var boyan_header_number = default_boyan_header_number;
	}
	else
	{
		var boyan_header_number = Number(selected_boyan_header)/2;
	}

	main_page(selected_page_index);
	select_page(selected_page_index);

	$("#boyan").accordion({ heightStyle: 'content', header: '.accordion-header', active: boyan_header_number});
	$("#boyan").accordion( "option", "collapsible", true );
	$(".index_number").button();
	//send_query();

	//$(".datetime").datepicker();
	//t1 = performance.now();
	//console.log('Took', (t1 - t0).toFixed(4));
	console.log(`Last commit datetime: ${commit_date.commit_date}`);
	show_commit_info();
});

function show_commit_info(){
	if (commit_info.commit_info['is_dirty'])
		dirty = "(M)"
	else{
		dirty = ""
	}
	var datetime = new Date(commit_info.commit_info['date_time']*1000);
	commit_date = get_set_value.dateYYYYMMDD(datetime)
	commit_time = get_set_value.timeHHmmss(datetime)
	$("#commit_info").append(`Commit: ${commit_info.commit_info['commit_hash']}${dirty}, ${commit_date} ${commit_time}, branch:(${commit_info.commit_info['active_branch']}) `);
}

function main_page(selected_page_index)
{
	var autoupdate_input = '<label><label class="autoupdate"><span></span></label> Autoupdate</label>'
	var raw_data_input = '<br><label><label class="raw_data"><span></span></label> Raw Values</label>'
	$("#main").append(autoupdate_input);
	$("#main").append(raw_data_input);

	var boyan = $('<div id="boyan">');
	//console.log(eds_object)
	$.each(configuration.expert_page_dictionary(), function(group_index, group_param)
	{
		var boyan_header = $('<div>').addClass('accordion-header');
		var boyan_body = $('<div>').addClass('accordion-body');

		boyan_header.html(group_param.name + '</br>&nbsp&nbsp&nbsp&nbsp' + group_param.minIndex + ' - ' + group_param.maxIndex );
		var minIndex = parseInt(group_param.minIndex)
		var maxIndex = parseInt(group_param.maxIndex)

		var find_some_index = false
		Object.keys(eds_object).sort().forEach(function(index)
		{
			var int_index = parseInt(`0x${index}`)

			if (int_index >= minIndex && int_index <= maxIndex)
			{
				find_some_index = true
				var index_div = $('<div>').addClass('index_number');
				var index_str = '#index' + index;
				index_div.text('0x' + index + ' ' + eds_object[index].ParameterName);
				index_div.attr({'id':index_str, 'onclick':"select_page('" + index + "');"});

				if (index == selected_page_index)
				{
					index_div.addClass('selected');
				}
				boyan_body.append(index_div);
			}
		})

		if (find_some_index)
		{
			boyan.append(boyan_header);
			boyan.append(boyan_body);
		}
	});
	$("#main").append(boyan);
}

function select_page(index_number)
{
	var table = $('<table>');
	var	table_name = $('<h4>').addClass('table_name');
	var table_header = $('<tr>').addClass('table_header');

	localStorage.setItem("selected_page_index", index_number);
	$("#second_html").html(''); //clear frame

	if (index_number in eds_object)
	{
		var name_comment = '';
		if (eds_object[index_number].Comment != "")
		{
			name_comment = '(' + eds_object[index_number].Comment + ')';
		}

		table_name.html('<b>0x' + index_number + '</b> \"' + eds_object[index_number].ParameterName + '\" ' + name_comment);

		//console.log(eds_object[index_number])
		//console.log(eds_object[index_number].subs)
		if (Object.keys(eds_object[index_number].subs).length > 0)
		{
			var request_array = [];
			for(var index in eds_object[index_number].subs) {
				request_array.push(eds_object[index_number].subs[index])
			}
			get_set_value.set_request_data(request_array);
			//get_set_value.set_expert_page_configuration();
			get_set_value.send_query();

			$.each(table_header_names, function (table_header_index, table_header_name)
			{
				var column_name = $('<td>').text(table_header_name);
				table_header.append(column_name);
			});
			table.append(table_header);


			for(var sub_index = 0; sub_index < Object.keys(eds_object[index_number].subs).length; sub_index++)
			{
				var sub_item_data = eds_object[index_number].subs[sub_index]
				//console.log(sub_item_data)
				//console.log(sub_item_data.index)
				if (sub_item_data != undefined)
				{
					if (sub_item_data.index != null)
					{
						//var table_row = $('<tr style="border-bottom: solid 1px black">');
						var table_row = $('<tr>');
						if (sub_index % 2 == 0)
						{
							table_row.addClass('marked')
						}
						var index_parts = sub_item_data.index.split(":");
						var index_str = index_parts[1];
						table_row.append($('<td>').text(index_str));
						table_row.append($('<td>').text(sub_item_data.ParameterName));
						table_row.append($('<td>').append(get_set_value.get_cell(sub_index)));
						table_row.append($('<td>').text(sub_item_data.DataType));
						table_row.append($('<td>').text(sub_item_data.DefaultValue));
						if (sub_item_data.Save == "Yes")
						{
							table_row.append($('<td>').text("Settings"));
						}
						else
						{
							table_row.append($('<td>').text(sub_item_data.Save));
						}
						table_row.append($('<td>').text(sub_item_data.Comment));
						table.append(table_row);
					}
				}
			}
		}
	}
	else
	{
		table_name.text(l100n.localize_string("index_error"))
	}


	$("#second_html").append(table_name);
	$("#second_html").append(table);
}

